/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt.style.outline.border;

import ej.annotation.Nullable;
import ej.bon.XMath;
import ej.drawing.ShapePainter;
import ej.microui.display.GraphicsContext;
import ej.mwt.style.outline.Outline;
import ej.mwt.util.Outlineable;
import ej.mwt.util.Size;

public class RoundedBorder
implements Outline {
    private static final int EMPTY_CIRCLE = 0;
    private static final int QUARTER_CIRCLE = 90;
    private static final int HALF_CIRCLE = 180;
    private static final int THREE_QUARTER_CIRCLE = 270;
    private static final int FADE = 1;
    private static final ShapePainter.Cap CAP = ShapePainter.Cap.ROUNDED;
    private final int color;
    private final char thickness;
    private final char cornerRadius;

    public RoundedBorder(int color, int cornerRadius, int thickness) {
        this.color = color;
        this.thickness = (char)XMath.limit((int)thickness, (int)0, (int)65535);
        this.cornerRadius = (char)XMath.limit((int)cornerRadius, (int)0, (int)65535);
    }

    public int getColor() {
        return this.color;
    }

    public int getThickness() {
        return this.thickness;
    }

    public int getCornerRadius() {
        return this.cornerRadius;
    }

    @Override
    public void apply(Outlineable outlineable) {
        char thickness = this.thickness;
        outlineable.removeOutline(thickness, thickness, thickness, thickness);
    }

    @Override
    public void apply(GraphicsContext g, Size size) {
        boolean fullCircle;
        boolean hasBackgroundColor = g.hasBackgroundColor();
        int backgroundColor = g.getBackgroundColor();
        g.removeBackgroundColor();
        int width = size.getWidth();
        int height = size.getHeight();
        char thickness = this.thickness;
        boolean emptyBorder = thickness == '\u0000';
        int cornerRadius = Math.min(this.cornerRadius, (Math.min(width, height) >> 1) - thickness);
        int borderSize = (cornerRadius + thickness << 1) + 1;
        boolean halfCircleHorizontal = borderSize >= width;
        boolean halfCircleVertical = borderSize >= height;
        boolean bl = fullCircle = halfCircleHorizontal && halfCircleVertical;
        if (!emptyBorder) {
            g.setColor(this.color);
        }
        int borderDiameter = cornerRadius << 1;
        int halfRectangle = thickness >> 1;
        int leftX = halfRectangle + 1;
        int topY = halfRectangle + 1;
        if (fullCircle) {
            ShapePainter.drawThickFadedCircle((GraphicsContext)g, (int)leftX, (int)topY, (int)borderDiameter, (int)thickness, (int)1);
        } else {
            int rightX = leftX + width - thickness - 2 - 1;
            int bottomY = topY + height - thickness - 2 - 1;
            if (halfCircleVertical) {
                ShapePainter.drawThickFadedCircleArc((GraphicsContext)g, (int)leftX, (int)topY, (int)borderDiameter, (float)90.0f, (float)180.0f, (int)thickness, (int)1, (ShapePainter.Cap)CAP, (ShapePainter.Cap)CAP);
                ShapePainter.drawThickFadedCircleArc((GraphicsContext)g, (int)(rightX - borderDiameter), (int)topY, (int)borderDiameter, (float)-90.0f, (float)180.0f, (int)thickness, (int)1, (ShapePainter.Cap)CAP, (ShapePainter.Cap)CAP);
            } else if (halfCircleHorizontal) {
                ShapePainter.drawThickFadedCircleArc((GraphicsContext)g, (int)leftX, (int)topY, (int)borderDiameter, (float)0.0f, (float)180.0f, (int)thickness, (int)1, (ShapePainter.Cap)CAP, (ShapePainter.Cap)CAP);
                ShapePainter.drawThickFadedCircleArc((GraphicsContext)g, (int)leftX, (int)(bottomY - borderDiameter), (int)borderDiameter, (float)180.0f, (float)180.0f, (int)thickness, (int)1, (ShapePainter.Cap)CAP, (ShapePainter.Cap)CAP);
            } else {
                ShapePainter.drawThickFadedCircleArc((GraphicsContext)g, (int)leftX, (int)topY, (int)borderDiameter, (float)90.0f, (float)90.0f, (int)thickness, (int)1, (ShapePainter.Cap)CAP, (ShapePainter.Cap)CAP);
                ShapePainter.drawThickFadedCircleArc((GraphicsContext)g, (int)leftX, (int)(bottomY - borderDiameter), (int)borderDiameter, (float)180.0f, (float)90.0f, (int)thickness, (int)1, (ShapePainter.Cap)CAP, (ShapePainter.Cap)CAP);
                ShapePainter.drawThickFadedCircleArc((GraphicsContext)g, (int)(rightX - borderDiameter), (int)(bottomY - borderDiameter), (int)borderDiameter, (float)270.0f, (float)90.0f, (int)thickness, (int)1, (ShapePainter.Cap)CAP, (ShapePainter.Cap)CAP);
                ShapePainter.drawThickFadedCircleArc((GraphicsContext)g, (int)(rightX - borderDiameter), (int)topY, (int)borderDiameter, (float)0.0f, (float)90.0f, (int)thickness, (int)1, (ShapePainter.Cap)CAP, (ShapePainter.Cap)CAP);
            }
            if (!halfCircleHorizontal) {
                int horizontalLeftX = leftX + cornerRadius + 1;
                int horizontalRightX = rightX - cornerRadius;
                int bottomLineY = bottomY + 1;
                ShapePainter.drawThickFadedLine((GraphicsContext)g, (int)horizontalLeftX, (int)topY, (int)horizontalRightX, (int)topY, (int)thickness, (int)1, (ShapePainter.Cap)CAP, (ShapePainter.Cap)CAP);
                ShapePainter.drawThickFadedLine((GraphicsContext)g, (int)horizontalLeftX, (int)bottomLineY, (int)horizontalRightX, (int)bottomLineY, (int)thickness, (int)1, (ShapePainter.Cap)CAP, (ShapePainter.Cap)CAP);
            }
            if (!halfCircleVertical) {
                int verticalTopY = topY + cornerRadius + 1;
                int verticalBottomY = bottomY - cornerRadius;
                int rightLineX = rightX + 1;
                ShapePainter.drawThickFadedLine((GraphicsContext)g, (int)leftX, (int)verticalTopY, (int)leftX, (int)verticalBottomY, (int)thickness, (int)1, (ShapePainter.Cap)CAP, (ShapePainter.Cap)CAP);
                ShapePainter.drawThickFadedLine((GraphicsContext)g, (int)rightLineX, (int)verticalTopY, (int)rightLineX, (int)verticalBottomY, (int)thickness, (int)1, (ShapePainter.Cap)CAP, (ShapePainter.Cap)CAP);
            }
        }
        size.removeOutline(thickness, thickness, thickness, thickness);
        g.translate((int)thickness, (int)thickness);
        g.intersectClip(0, 0, size.getWidth(), size.getHeight());
        if (hasBackgroundColor) {
            g.setBackgroundColor(backgroundColor);
        }
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj instanceof RoundedBorder) {
            RoundedBorder border = (RoundedBorder)obj;
            return this.color == border.color && this.thickness == border.thickness && this.cornerRadius == border.cornerRadius;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 17 * this.color + this.thickness * this.cornerRadius;
    }
}

