/*
 * Decompiled with CFR 0.152.
 */
package ej.net.util.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.Set;

public class CertificatesHelper {
    private static final String CERTIFICATE_TYPE = "X.509";

    private CertificatesHelper() {
    }

    public static X509Certificate loadCertificate(InputStream inputStream) throws CertificateException {
        CertificateFactory certificateFactory;
        try {
            certificateFactory = CertificateFactory.getInstance(CERTIFICATE_TYPE);
        }
        catch (CertificateException e) {
            throw new UnsupportedOperationException(e);
        }
        return (X509Certificate)certificateFactory.generateCertificate(inputStream);
    }

    public static X509Certificate getCertificate(String path) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream inputStream = CertificatesHelper.class.getResourceAsStream(path);){
                if (inputStream == null) {
                    throw new IllegalArgumentException("Cannot get resource \"" + path + "\"");
                }
                return CertificatesHelper.loadCertificate(inputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CertificateException e) {
            throw new IllegalArgumentException("Cannot generate certificate from resource \"" + path + "\"", e);
        }
    }

    public static String[] loadCertificatesList(InputStream certificatesList) throws IOException {
        Properties properties = new Properties();
        properties.load(certificatesList);
        Set<String> propertiesSet = properties.stringPropertyNames();
        return propertiesSet.toArray(new String[propertiesSet.size()]);
    }
}

