/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.http.requesthandler;

import ej.annotation.Nullable;
import ej.hoka.http.HttpServer;
import ej.hoka.http.requesthandler.StaticFilesHandler;
import ej.hoka.http.support.Mime;
import ej.hoka.log.HokaLogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class ClasspathFilesHandler
implements StaticFilesHandler {
    private static final String GZIP_FILE_EXTENSION = ".gz";
    private static final String CONTENT_ENCODING_GZIP = "gzip";
    private static final String DEFAULT_INDEX = "index.html";
    private static final String DIRECTORY_TRAVERSAL_SEQUENCE = "..";
    private final String root;
    private final String index;
    private final int expireTimeSeconds;
    private final boolean guessMimeType;

    private ClasspathFilesHandler(String rootDirectory, String welcomeFile, int expirationTime, boolean guessMimeType) {
        this.root = rootDirectory;
        this.index = welcomeFile;
        this.expireTimeSeconds = expirationTime;
        this.guessMimeType = guessMimeType;
    }

    public static ClasspathFilesHandlerBuilder builder() {
        return new ClasspathFilesHandlerBuilder();
    }

    @Override
    @Nullable
    public InputStream serve(String path, Map<String, String> headers) {
        InputStream resourceStream;
        String uri = String.valueOf(this.root) + path;
        if (uri.contains(DIRECTORY_TRAVERSAL_SEQUENCE)) {
            HttpServer.halt("403 Forbidden");
        }
        if (uri.endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        if (this.root.equals(uri)) {
            uri = String.valueOf(uri) + "/" + this.index;
        }
        if ((resourceStream = this.getClass().getResourceAsStream(uri)) == null) {
            return null;
        }
        try {
            int contentLength = resourceStream.available();
            headers.put("content-length", "" + contentLength);
        }
        catch (IOException e) {
            String msg = "error while getting resource size" + e.getMessage();
            HokaLogger.instance.trace(msg);
        }
        if (this.guessMimeType) {
            String mimeType = this.getMimeType(uri);
            headers.put("content-type", mimeType);
            if (CONTENT_ENCODING_GZIP.equals(mimeType)) {
                headers.put("content-encoding", CONTENT_ENCODING_GZIP);
            }
        }
        if (this.expireTimeSeconds > 0) {
            headers.put("cache-control", "private, max-age=" + this.expireTimeSeconds);
        }
        return resourceStream;
    }

    private String getMimeType(String uri) {
        String mimeType = uri.endsWith(GZIP_FILE_EXTENSION) ? Mime.getMIMEType(uri.substring(0, uri.length() - GZIP_FILE_EXTENSION.length())) : Mime.getMIMEType(uri);
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        return mimeType;
    }

    /* synthetic */ ClasspathFilesHandler(String string, String string2, int n, boolean bl, ClasspathFilesHandler classpathFilesHandler) {
        this(string, string2, n, bl);
    }

    public static class ClasspathFilesHandlerBuilder {
        private String root = "";
        private String index = "index.html";
        private int expireTimeSeconds;
        private boolean guessMimeType = false;

        private ClasspathFilesHandlerBuilder() {
        }

        public ClasspathFilesHandlerBuilder rootDirectory(String root) {
            this.root = root;
            if (this.root.endsWith("/")) {
                this.root = this.root.substring(0, this.root.length() - 1);
            }
            return this;
        }

        public ClasspathFilesHandlerBuilder welcomeFile(String welcome) {
            this.index = welcome;
            return this;
        }

        public ClasspathFilesHandlerBuilder expireTimeSeconds(int expireTimeSeconds) {
            this.expireTimeSeconds = expireTimeSeconds;
            return this;
        }

        public ClasspathFilesHandlerBuilder guessMimeType() {
            this.guessMimeType = true;
            return this;
        }

        public ClasspathFilesHandler build() {
            return new ClasspathFilesHandler(this.root, this.index, this.expireTimeSeconds, this.guessMimeType, null);
        }
    }
}

