/*
 * Java
 *
 * Copyright 2018 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.bluetooth;

import ej.bluetooth.callbacks.ServerCallbacks;

/**
 * The <code>BluetoothCharacteristic</code> class represents a remote or a local GATT characteristic.
 * <p>
 * Remote characteristics may be retrieved from a Bluetooth device by {@link BluetoothDevice#discoverServices
 * discovering its services} and {@link BluetoothService#getCharacteristics getting their characteristics}.
 * <p>
 * Local characteristics may be created by using the {@link #BluetoothCharacteristic class constructor} and
 * {@link BluetoothService#addCharacteristic added} to a local service.
 * <p>
 * This class provides methods to get information on the characteristic. It also provides methods to add descriptors and
 * to send notifications on a local characteristic.
 */
public class BluetoothCharacteristic extends BluetoothAttribute {

	/**
	 * Creates a local characteristic with the given UUID, properties and permissions.
	 * <p>
	 * This characteristic may then be {@link BluetoothService#addCharacteristic added} to a local service.
	 *
	 * @param uuid
	 *            the characteristic UUID.
	 * @param properties
	 *            the characteristic properties (see {@link BluetoothProperties}).
	 * @param permissions
	 *            the characteristic permissions (see {@link BluetoothPermissions}).
	 */
	public BluetoothCharacteristic(BluetoothUuid uuid, int properties, int permissions) {
		throw new RuntimeException();
	}

	/**
	 * Adds a descriptor to this characteristic.
	 *
	 * @param descriptor
	 *            the descriptor to add.
	 * @throws IllegalStateException
	 *             if this characteristic belongs to a remote device.
	 * @throws IllegalStateException
	 *             if the service of this characteristic has already been added to an adapter.
	 * @throws IllegalStateException
	 *             if the descriptor has already been added to a characteristic.
	 */
	public void addDescriptor(BluetoothDescriptor descriptor) {
		throw new RuntimeException();
	}

	/**
	 * Returns the properties of this characteristic.
	 *
	 * @return the properties of this characteristic (see {@link BluetoothProperties}).
	 */
	public int getProperties() {
		throw new RuntimeException();
	}

	/**
	 * Returns the list of descriptors of this characteristic.
	 *
	 * @return the list of descriptors of this characteristic.
	 */
	public BluetoothDescriptor[] getDescriptors() {
		throw new RuntimeException();
	}

	/**
	 * Finds the descriptor of this characteristic which matches the given UUID.
	 * <p>
	 * If multiple descriptors have the same UUID, any of them may be returned.
	 *
	 * @param descriptorUuid
	 *            the UUID of the descriptor to find.
	 * @return the descriptor found, or null if it can not be found.
	 */
	public BluetoothDescriptor findDescriptor(BluetoothUuid descriptorUuid) {
		throw new RuntimeException();
	}

	/**
	 * Sends a notification on this characteristic to the given device with the given value.
	 *
	 * @param device
	 *            the device to which the notification should be sent.
	 * @param value
	 *            the value to send.
	 * @param confirm
	 *            true to request a confirmation (GATT indication), false otherwise (GATT notification).
	 * @return true if the notification was sent successfully.
	 * @throws IllegalStateException
	 *             if this characteristic belongs to a remote device.
	 * @throws IllegalStateException
	 *             if this characteristic has not been added to a service
	 * @throws IllegalStateException
	 *             if the service of this characteristic has not been added to an adapter.
	 * @see ServerCallbacks#onNotificationSent(BluetoothCharacteristic, BluetoothDevice, boolean)
	 */
	public boolean sendNotification(BluetoothDevice device, byte[] value, boolean confirm) {
		throw new RuntimeException();
	}
}
