# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## 4.0.0 - 2021-02-05

### Changed

- Split motion functions from motion class.
- Rename none function to constant function.
- Compute function value on `float` rather than on `int`.
- Simplify ease out and ease in out functions by using ease in functions.
- Update functions to synchronize with the latest version of [easings.net](https://easings.net/).
- Use null analysis annotations.
- Use MMM.
- Update format of readme and changelog files.

### Removed

- Remove motion manager.
- Remove motion animator.
- Remove motion factory.
- Remove toss helper.

### Fixed

- Fix bounce, elastic and cubic functions.

## 3.1.1 - 2017-10-13

### Fixed

- Use `Util.platformTimeMillis()` rather than `System.currentTimeMillis()`.

## 3.1.0 - 2017-01-19

### Added

- Add motion factory.

## 3.0.2 - 2016-04-01

### Changed

- Update artifacts to be compliant with MicroEJ 4 repository.

## 3.0.0 - 2015-07-27

### Added

- Add more easing functions.
- Add `Motion.getValue(long)` for a specific elapsed time.
- Add `Motion.getDuration()`.
- Add the possibility to cancel a running motion animator.

### Deprecated

- Set `MotionManager.toss()` deprecated.

## 2.1.4 - 2015-07-07

### Changed

- Change module organization to `ej.library.ui` and rename module to `motion`.

## 2.1.4 - 2015-06-25

### Changed

- Change module buildtype to `build-microej-javalib`.

## 2.1.2 - 2014-05-16

### Fixed

- Fix ease in/out motion generating irregular values.
- Fix motion animator issue when chaining motions.

## 2.1.1 - 2014-05-06

### Fixed

- Fix last step of bounce motion.

## 2.1.0 - 2014-04-24

### Fixed

- Fix premature end of bounce and elastic motions.

## 2.0.0 - 2014-04-14

### Added

- Add a motion that does nothing.

### Changed

- Use `float` instead of `double`.

### Fixed

- Fix premature end of bounce and elastic motion.
- Fix ease in/out motion not being smooth.

## 1.0.1 - 2014-03-11

### Added

- Add readme.

## 1.0.0 - 2014-03-07

### Added

- Initial revision.

---  
_Copyright 2014-2021 MicroEJ Corp. All rights reserved._  
_This library is provided in source code for use, modification and test, subject to license terms._  
_Any modification of the source code will break MicroEJ Corp. warranties on the whole library._  
