# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## 2.0.0 - 2024-02-26

### Added
  - Add `SecurityLevels` class that enumerates the security levels of GATT attributes.
  - Add `getReadPermission()` and `getWritePermission()` methods in `ServiceHelper` to get a permission for a given security level.

### Changed
  - Set service listener in new `start()` method rather than in constructor in client and server implementations.
  - Rename `close()` method to `stop()` in client and server implementations.
  - Throw `IllegalArgumentException` rather than `AttributeNotFoundException` in constructor of server implementations.

### Removed
  - Remove `CUD_PERMISSIONS` and `CCC_PERMISSIONS` constants in `DescriptorHelper`.

### Fixed
  - Fix string representation of properties printed by `ServiceHelper.printService()`.

## 1.1.1 - 2024-02-02

### Changed
  - Update license file.
  - Update buildtype version to 6.2.+.
  - Update edc dependency to 1.3.3.

## 1.1.0 - 2020-12-21

### Added
  - Add support for service UUIDs in advertisement data builder/parser.

### Changed
  - Update bluetooth dependency to 2.1.0.

## 1.0.1 - 2020-05-26

### Added
  - Add advertisement data test.

### Fixed
  - Use `Arrays.copyOf()` rather than `byte[].clone()`.

## 1.0.0 - 2020-05-04

### Added
  - Implement advertisement data builder and parser.
  - Implement service helper.
  - Implement descriptor helper.
  - Implement Current Time Service.
  - Implement Serial Port Service.

### Changed
  - Update license file.

## 0.1.0 - 2019-07-12

### Added
  - Initial revision.

---
_Copyright 2019-2024 MicroEJ Corp. All rights reserved._  
_This library is provided in source code for use, modification and test, subject to license terms._  
_Any modification of the source code will break MicroEJ Corp. warranties on the whole library._  
