# Overview

MicroEJ Foundation Library: `microai-lib`.

This Foundation Library provides:
- a low-level API for MicroAI (LLML).
- an implementation of the MicroAI API based on this low-level API.
- a VEE Port init script which configures the MicroAI implementation.

# Usage

## Gradle Dependencies
Add the following line to your VEE Port `build.gradle.kts`:
```
    MicroejPack("ej.api:microai:<version>")
```
And in your Application `build.gradle.kts`:
```
    implementation("ej.api:microai:<version>")
```

## MicroAI Heap Size

In the VEE Port, copy [microai-init.xml](./content/scripts/init-microai/microai-init.xml)
to `vee-port/dropins/scripts/init-microai/microai-init.xml`

Then in your application, set the size in bytes `microai.heap.size=<model size in bytes>`

This heap is only used in the case the model is provided as an InputStream and so needs to be extracted into the heap memory.

If the model is provided as a Java resource, then the heap will not be use and you can set `0`.

# Requirements


# Dependencies

_All dependencies are retrieved transitively by Gradle_.

# Source

N/A.

# Restrictions

None.

---
_Markdown_  
_Copyright 2025 MicroEJ Corp. All rights reserved._  
_Use of this source code is governed by a BSD-style license that can be found with this software._  
