# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [2.3.0] - 2023-07-21

### Added

  - Add test cases for DST_OUT and PLUS blend modes.
  - Add tests for path bounds.
  - Add tests to check that loading a font from a path without a leading slash fails.
  - Add tests for drawing empty strings and strings outside of the clip area.

### Fixed

  - Make BVI tests compatible with Android.
  - Do not print debug logs in TestFontMeasures, TestImageExternal and TestPath when the debug constant is not set.

## [2.2.0] - 2023-05-10

### Added

  - Add tests on invalid "external images".
  - Add compatibility tests to check that BufferedVectorImage can be used in place of VectorImage in the API.
  - Add a test for memory leaks when closing a BufferedVectorImage.
  - Add a test to check an image with several gradients.
  - Add a test for an animated images with different path interpolators.
  - Add tests to check out-of-memory error reporting when using BufferedVectorImages.
  
### Changed

  - Publish the testsuite jar in addition with to the rip file.
  
### Fixed

  - Fix "external image" tests: close the images and calibrate the images heap.

## [2.1.0] - 2023-02-06

### Added

  - Add test to check the clip and the translation when drawing an image.
  - Add test to check the "empty" drawings of a string.

### Fixed

  - Make TestImageExternal and TestPath compatible with Android.
  - Do not print debug logs in TestMatrix when the debug constant is not set.

## [2.0.1] - 2022-12-30

### Fixed

  - TestBlendMode requires a non-null image heap size. 

## [2.0.0] - 2022-12-29

### Added

  - Add a mechanism to run the full testsuite and a single test (in MicroEJ launch mode) using the same properties.
  - Add test to check the side effects on Matrix.setConcat().
  - Add tests for resource image closing.
  - Add tests for external image loading.
  - Add drawOnCircle tests with complex layouts.
  - Add test with a very long path.
  - Add more cases in blend mode test.

### Changed

  - Close images in the color filter tests.
  - Change test accuracy for Android (new pixel difference formula).
  - Each test embeds only the necessary resources (not all the resources).

### Removed

  - Remove the "wrong" vector image (no meaning with RAW format).

### Fixed

  - Add missing clearScreen before FontExternal tests.
  - Fix expected results for SRC and SRC_IN blend modes.
  - Add tests for elapsed time outside the animated image duration.

## [1.1.0] - 2022-09-02

### Added

  - Add test to check the use of external VectorFonts.
  - Restore tests that close a VectorFont.
  - Add test to check the use of VectorImageBuilder.
  - Add test for complex text layout feature.
  - Adjust some expected results to match Android specification.

### Changed

  - Adapt drawStringOnCircle tests as character bboxes are joined at baseline.
  
## [1.0.0] - 2022-05-13

### Added

  - Extract microvg-impl tests.
  - Extract VectorFont tests.

---  
_Copyright 2022-2023 MicroEJ Corp. All rights reserved._  
_Use of this source code is governed by a BSD-style license that can be found with this software._  
