# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [12.0.0] - 2025-04-10

- NET: API=1.1.4, IMPL=9.0.0, MOCK=6.0.0, TEST=4.1.1
- SSL: API=2.2.3, IMPL=8.0.1, MOCK=7.0.0, TEST=4.0.2
- SEC: API=1.7.0, IMPL=3.0.0, MOCK=3.0.0, TEST=1.9.0

### Added

- SECURITY: Add initialization method to LLAPI for the native implementation to initialize its components (such as an async worker to allow delegation of long-blocking native calls to a native worker thread, preventing the VM from being blocked and enabling it to schedule other Java threads).
- SECURITY: Update the test suite to verify that the VM can effectively schedule other Java threads during these native calls.

### Fixed

- SECURITY: Native resources shared between a `PrivateKey` and a `PublicKey` instance generated by `KeyPairGenerator` could be prematurely freed if the `PrivateKey` instance went out of scope and is garbage collected. Implement shared ownership to keep native context as long as it is referenced by either instances.

## [11.3.0] - 2025-03-13

- NET: API=1.1.4, IMPL=9.0.0, MOCK=6.0.0, TEST=4.1.1
- SSL: API=2.2.3, IMPL=8.0.1, MOCK=7.0.0, TEST=4.0.2
- SEC: API=1.7.0, IMPL=2.5.1, MOCK=2.7.0, TEST=1.8.0

### Added

- Security (SIM): Added support for `AES/CTR/NoPadding` cipher.

### Fixed

- Security (SIM): Fix cipher encrypt and decrypt when output offset is not 0.

## [11.2.0] - 2024-12-18

- NET: API=1.1.4, IMPL=9.0.0, MOCK=6.0.0, TEST=4.1.1
- SSL: API=2.2.3, IMPL=8.0.1, MOCK=7.0.0, TEST=4.0.2
- SEC: API=1.7.0, IMPL=2.5.1, MOCK=2.6.0, TEST=1.8.0

### Added

- Security: HMAC SHA1 and MD5 support in mock, testsuite and ABLA

### Fixed

- Security: an issue where enums were considered as uint8 instead of uint32, causing inconsistency with the Java API. Updated the C implementation to use the uint32 type for alignment with Java.

## [11.1.0] - 2024-07-09

- NET: API=1.1.4, IMPL=9.0.0, MOCK=6.0.0, TEST=4.1.1
- SSL: API=2.2.3, IMPL=8.0.1, MOCK=7.0.0, TEST=4.0.2
- SEC: API=1.7.0, IMPL=2.5.0, MOCK=2.5.0, TEST=1.7.0

### Added

- Security: Added support for Password-Based Encryption (PBE).
- Security: Added support for RSA cipher initialization with OAEP parameters.
- Security (SIM): Added support for `DESede/CBC/NoPadding` cipher.

### Changed

- License: Updated to SDK/BSD Dual License v1.2.

### Fixed

- Security: Fixed an issue where using the same (IV) for symmetric ciphers during subsequent `doFinal` operations caused problems.
- Security (SIM): Fixed the `cipherMode` data from a native cipher transformation.
- Security (SIM): Fixed memory leaks by unregistering native resources.
- Security (SIM): Fixed the use of symmetric ciphers without explicit re-initialization.
- SSL: Fixed SSL API detection by MICROEJ SDK.
  
## [11.0.2] - 2023-09-15

### Changed

- SSL: Renamed `ssl.system.properties` to `ssl.system.properties.list` for architecture 8 compatibility.

## [11.0.1] - 2022-09-05

### Fixed

  - Fix build fragments: update modules names.
  - Fix Ivy configuration: keep all dependencies private.

## [11.0.0] - 2022-08-26

### Added

  - Net & SSL foundation lib implementation on SNI 1.3

### Removed

  - Remove net-embedded-dns dependency (native DNS is now the only one DNS implementation since soft DNS is no longer supported and removed)

### Changed

  - Change organization name to: `com.microej.pack.net`.
  - Change module name to: `net-pack`.
  - Change organization & module names of dependencies.
  - Update licensing.

## [10.0.0] - 2021-10-11

### Added

  - Make the project MMM 5 compatible

### Changed

  - Use fixed version for all pack dependencies
  - Update version of ej.api#net to 1.1.2
  - Update version of ej.api#ssl to 2.2.1
  - Update version of ej.api#security to 1.4.0
  - Update version of com.is2t.libraries.security#security-impl 2.0.0
  - Update version of com.is2t.libraries.security#security-mockup 2.0.0
  - Update version of com.is2t.libraries.ssl-embedded#ssl-embedded 7.2.1
  - Update version of com.is2t.libraries.ssl-embedded#ssl-embedded-s3 6.1.1

### Fixed

  - Regression on setPrivateKey(): The password length passed to the native should not include the null terminating byte.

## [9.4.0] - 2021-05-07

### Added

  - Remove pool of immortals buffers. Update net impl, mock and ssl impl deps.

## [9.3.0] - 2020-12-19

### Added

  - Add customizable buffer size for X509 certificate loading. New LLAPI LLSEC_X509_CERT_IMPL_get_key_size() added.

### Fixed

  - Security Mockup: IndexOutOfBoundsException after freeing a MessageDigest

## [9.2.3] - 2020-11-05

### Fixed

  - Fix wrong packaging.
  - Update License to LAW-0011-LCS-MicroEJSDK-EULA-3.0-B. 

## [9.2.2] - 2020-07-06

### Fixed

  - Fix CertificateException when using SSL. 

## [9.2.1] - 2020-04-23

### Fixed

  - Security: Load required types from script instead of `.types.list`.

## [9.2.0] - 2020-01-30

### Fixed

  - Security: Fix wrong return type in Cipher API.
  - Security: Add missing nativeGetBufferedLength native in Cipher API.
  - Security: Fix LLSEC API documentation.
  - Security: Implement a missing CipherSpi.engineInit method.

## [9.1.1] - 2019-05-23

### Fixed

  - Fix missing require type for TLS 1.3 support

## [9.1.0] - 2019-03-29

### Added

  - Add TLS 1.3 support in SSL foundation library.
  - Update Digest implementation in Security foundation library mock to remove restriction on SHA-256 algorithm.

## [9.0.3] - 2019-03-27

### Fixed

  - Fix wrong include in `LLSEC_RANDOM_impl.h` header file.
 
## [9.0.2] - 2019-03-08

### Fixed

  - Add bug fixes on Security foundation library.
  - Fix Security foundation library low level API wrong X509 parse function signature. 
  
## [9.0.1] - 2019-03-08

### Fixed

  - Add bug fixes on Security foundation library.
  - Fix Security foundation library packaging issue that do not contains low level APIs.
  - Set ContextLocalStorage for NativeResources to fix a KF issue in Security foundation library.

## [9.0.0] - 2019-03-01

### Added

  - Add Security foundation library.
  - Remove useless low level API based on X509 certificate parse (now done by Security foundation library).

### Fixed

  - Clean SSL workbench extension packaging.
  - Clean NET workbench extension packaging.
  - Fix SSL llapi artifact dependency organisation and module name.
  - Fix SSL testsuite launch scripts issue.

## [8.2.0] - 2019-01-29

### Added

  - Support TLS SNI client-side

## [8.1.6] - 2019-01-29

### Fixed

  - Fix wrong SSL artifact name

## [8.1.5] - 2018-10-15

### Fixed

  - Allow to retrieve the underlying native file descriptor from a datagram socket.
  - Allow to subclass SSLContext for dtls.

## [8.1.4] - 2018-08-31

### Fixed

  - Use the net embedded resources 1.1.0.

## [8.1.3] - 2018-07-27

### Fixed

  - LLNET API: port format in LLNET_DATAGRAMSOCKETCHANNEL_IMPL_receive not specified

## [8.1.2] - 2018-07-18

### Fixed

  - Generic pack generation instead of architecture specific

## [8.1.1] - 2018-06-04

### Fixed

  - Net pack scripts may reference a directory that doesn't exist

## [8.1.0] - 2018-01-22

### Fixed

  - Net Library and Pack review, optimization and refactoring
  - Update to WolfSSL 3.10.2

## [8.0.0] - 2017-11-06

### Fixed

  - Net: Remove dispatch from the pack

## [7.0.0] - 2017-10-10

### Fixed

  - SSL ServerSocket implementation
  - Bidirectional SSL

## [6.1.5] - 2017-06-21

### Fixed

  - Soft DNS resolver doesn't retry on timeout and doesn't try other servers on errors
  - DNS soft should be case insensitive on hostname

## [6.1.4] - 2017-03-31

### Fixed

  - Virtual Devices are slow to enumerate network interfaces
  - Missing documentation on native NetworkInterfaceNatives.getVMInterface(int, byte[], int, int, boolean)

## [6.1.3] - 2017-03-14

### Fixed

  - Wrong labels on Net Workbench Extension

## [6.1.2] - 2017-03-06

### Fixed

  - Some Readme and changelog files not embed
  - SSL C header files missing

## [6.1.1] - 2017-03-03

### Fixed

  - Missing description for Net and SSL in MicroEJ SDK 4 .platform -> content view -> details -> description

## [6.1.0] - 2016-12-29

### Added

  - Updated all dependencies for NET 1.1 compatibility

## [6.0.0] - 2016-11-22

### Added

  - Add retry pattern on all SSL natives

## [5.1.0] - 2016-11-16

### Added

  - Net 1.1

### Fixed

  - Fix issue in the Java implementation of the DNS resolver with unknown hosts on multiple CNAME entries

## [5.0.2] - 2016-07-13

### Added

  - Memory leak issue fixed in soft DNS part when resolving unknown host name.

## [5.0.1] - 2016-07-04

### Added

  - Artifacts API retrieved from "ej.api" instead of "com.is2t.libraries.net-embedded"

## [5.0.0] - 2016-03-17

### Added

  - Add DNS Java support in XPFP Net
  - Net Embedded KF ready
  - Update Net native method to match right arguments when buffer exchanged
  - Add "network not initialized" specific error code

### Fixed

  - DNS Client host IP address resolution failed on multiple request
  - SSL JavaDoc API build fails with jdk8 due to references to non-existent classes and methods in the API
  - Net API javadoc doest not build with jdk8 

## [4.0.0] - 2016-01-29

### Added

  - Pull-up TCP/IP stack error codes
  - Net-Embedded Low Level APIs documentation
  - Remove API JavaDoc from Net-Embedded implementation
  - Net-Embedded Impl on OpenJDK - remove GNU-Classpath Copyright
  - Remove javadoc from SSL implementation
  - SSL Low Level APis documentation
  
## [3.0.0] - 2016-01-11

### Added

  - Certificate chain validation implem

## [2.1.0] - 2016-01-04

### Added

  - SSL Immortals allocation optimisation
  - SSL context automatic recycle
  - Pull up SSL error code Emb+Sim

### Fixed

  - Net API issue on NetworkInterface.getNetworkInterfaces() method

## [2.0.0] - 2015-12-07

### Added

  - SSL TrustStore implementation 

### Fixed

  - LLNET_Cfg.h header file missing in network settings workbench extension artifact

## [1.2.0] - 2015-11-12

### Added

  - Optimization of read/writes native call operations in Net library.

## [1.1.1] - 2015-10-30

### Added

  - Keep backward compatibility with old Platform Architecture which do not have resource manager. 

## [1.1.0] - 2015-10-30

### Added

  - Initial revision.

---
_Copyright 2015-2025 MicroEJ Corp. All rights reserved._  
_This library is provided in source code for use, modification and test, subject to license terms._  
_Any modification of the source code will break MicroEJ Corp. warranties on the whole library._
