# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [4.2.1] - 2025-11-26

### Fixed

  - ServerSocketAcceptTimeout: fix port to 5557 like for the remote application

## [4.2.0] - 2025-10-13

### Fixed

  - Use monotonic clock (ej.bon.Util.platformTimeMillis()) when testing for timeout

### Added

  - Add a TCP robustness test (com.microej.net.test.group.TestSocketParallel). See [README.md](README.md) for details on how to configure this test.

## [4.1.2] - 2025-01-20

### Fixed

  - Fix a false positive memory leak check

## [4.1.1] - 2022-04-29

### Fixed

  - Remove remote service check in non remote tests.
  - Set private-default conf for remote dependency.
  - Remove remote init service set in init scripts.
  - Fix remote app timeout in init scripts.
  - An existing empty try with resource block causes a SOAR error when building the test `TestHostNameResolution01`.

## [4.1.0] - 2022-04-14

### Changed

 - Remote are launched from a separate .jar.

### Removed

 - Remote test classes.

### Fixed

 - Fix classname in init script
 - Raise timeout value in TestServerSocketAcceptTimeout2.

## [4.0.0] - 2022-03-30

### Fixed

 - Fix empty Try with Resource block causes an Internal SOAR error.

### Removed

 - Remove useless remote.machine.waitAndCloseClient property.

### Changed

 - Rename `remote.machine.timeout` to `remoteapp.timeout`.
 - `TestServerSocketAcceptTimeout1`: Change server port `5555` to `5557` as `5555` is usually used by Serial To Socket Transmitter tool.
 - Update generated wrapper for OpenJDK NET tests to use testsuite harness.
 - Rename Java packages name to `com.microej.net.test.*`.
 - Publish OpenJDK tests in their own module.
 - Update projects skeleton with SDK 5.5.

## [3.6.0] - 2021-07-13

### Added

  - Add test for DNS resolution.
  - Add the property remote.machine.timeout and remote.machine.waitAndCloseClient to configure remote application timeout in PQT testsuite projects.

### Fixed

  - Test SocketClosedException: Check the thrown exception type instead of the exception message which is not standard.

## [3.5.3] - 2020-11-09

### Fixed

  - `NET=-7` fix address already in use issue.

## [3.5.2] - 2020-04-17

### Fixed

  - Remove useless `netif.name` property for J2SE remoteapp tests. Property `init.service=remoteapp`
   has to be set by user wanting to launch J2SE remoteapp tests manually.

## [3.5.1] - 2020-02-24

### Fixed

  - Dual stack tests not configured correctly in IPv4 mode.
  - Add test for Async-select bug where a request may not be executed.
  - Fix issue in test TestSocketPermisionOnAccept with IPv6.

## [3.5.0] - 2020-02-07

### Added

  - Review configuration for IPv6 and dual-stack testsuites and add documentation in the readme.

### Fixed

  - Fix IP address used in TestSocketPermissionOnAccept.
   
## [3.4.1] - 2020-02-06

### Fixed

  - Test TestDualStackDatagram doesn't wait to receive enough message before stopping.

## [3.4.0] - 2018-12-20

### Added

  - Add tests for dual-stack (IPv4+IPv6).

### Fixed

  - Fix tests that are not compatible with IPv6.

## [3.3.1] - 2018-08-07

### Fixed

  - Wrong GetMTU test bug fix (MTU returned can be 0).
  - Add some error message when something goes wrong in `TestSocketTimeout2`.

## [3.3.0] - 2018-06-05

### Added

  - Add tests for `InetAddress.isSiteLocalAddress()`.

### Fixed

  - Fix reference to unknown property.
  - Fix false-negative test that detected a memory leak.
  - Fix TestSocketTimeout2 that may not work for some network configurations.

## [3.2.2] - 2018-05-30

### Fixed

  - Fix reference to unknown property.
  - Network tests related to buffer size don't pass on Linux.
  - Net testsuite: wrong local programs launched.
  
## [3.2.1] - 2018-05-14

### Fixed

  - Network testsuite: Fix group tests that are not written correctly.
  - Classpath not defined correctly in the Network Testsuite.

## [3.2.0] - 2017-03-10

### Added

  - Add test to check that datagram packet can use buffer size of 1024.
  - Isolate integration tests for NET and SSL.

### Changed

  - Change datagram buffer size to default net io buffer size (256).

## [3.1.0] - 2016-12-26

### Added

  - The IPv4 stack is used by default. Tests can switch to IPv6 using the java.net.preferIPv4Stack and java.net.preferIPv6Stack
  parameters.
  
### Fixed

  - TestDatagramSocket could block forever due to a missing timeout on the device socket.
  - The test harness could call NetworkInterface.getByName before the network interface was actually initialized, causing an
  unhandled exception.
  - Network test app can loop indefinitely if not finding the correct interface for test purpose.
  - Network tests and remoteapp and can't run on the same machine.

## [3.0.0] - 2016-07-12

### Added

  - Remote testsuite mode added. The user could use the property 'testsuite.islocal' (value are 'true' or 'false') to
  decide if a server is mount during each test or if a global instance with all remote testcase is used. 
  - User has to give the name of the Java network interface used during all tests. This information has to be set with 
  Java property 'netif.name'. The Java property 'init.sleep' is now removed and a polling on the IP address of the 
  required interface is now done to wait the end of initialisation and configuration.
  - All tests begins with a connection to a remote host. If the board test is a server test. First, the board is connecting
  to the testsuite server to retrieve the board IP address and then the server test on the board start. 
  - The user could now define a specific initialisation step by using the 'init.service' Java property. This one refers
  to an implementation of the 'INetInit' Java interface and will be call before starting a test case. 

---

_Copyright 2014-2025 MicroEJ Corp. All rights reserved._  
_Use of this source code is governed by a BSD-style license that can be found with this software._  
