/*
 * Copyright 2024-2025 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package com.microej.wear.services;

/**
 * This service allows Features to navigate across the UI.
 */
public interface NavigationService {

	/**
	 * Handles a displayable event.
	 * <p>
	 * The navigation service may detect a gesture and show an other page.
	 *
	 * @param event
	 *            the event to handle.
	 * @return whether the event has been consumed.
	 */
	boolean handleEvent(int event);
}
