/*
 * Copyright 2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.microvg.image.pathdata;

import ej.microvg.image.ImageGenerator;
import ej.microvg.image.ImageGenerator.Format;
import ej.microvg.image.Path;

/**
 * A path data organizes the data of a path: the commands and their parameters. It also holds the path's bounds.
 *
 * @see Path#encode(PathData)
 * @see ImageGenerator#encodePath(Path)
 */
public interface PathData {

	/**
	 * Resets the path data buffer(s).
	 */
	void reset();

	/**
	 * Appends a command.
	 *
	 * @param command
	 *            the command to add
	 */
	void appendCommand(int command);

	/**
	 * Appends a coordinate.
	 *
	 * @param coordinate
	 *            the coordinate to add
	 */
	void appendCoordinate(double coordinate);

	/**
	 * Gets the format used to encode the path data.
	 *
	 * @return a {@link Format}
	 */
	Format getFormat();

}
