/*
 * Copyright 2015-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.mwt.style.outline;

import ej.annotation.Nullable;
import ej.microui.display.GraphicsContext;
import ej.mwt.util.Outlineable;
import ej.mwt.util.Size;

/**
 * An outline that is empty.
 */
public final class NoOutline implements Outline {

	/**
	 * No outline singleton to avoid creating several ones.
	 */
	public static final NoOutline NO_OUTLINE = new NoOutline();

	private NoOutline() {
	}

	@Override
	public void apply(Outlineable outlineable) {
		// Nothing to do.
	}

	@Override
	public void apply(GraphicsContext g, Size size) {
		// Nothing to do.
	}

	@Override
	public boolean equals(@Nullable Object obj) {
		return (obj == this);
	}

	@Override
	public int hashCode() {
		return -1706589226;
	}
}
