/*
 *	Java
 *
 *	Copyright 2015-2016 IS2T. All rights reserved.
 *	IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package ej.microui.display.transform;

import ej.microui.display.GraphicsContext;
import ej.microui.display.Image;

/**
 * The {@link AbstractTransform} class holds a generic context for all kinds of transformations (see sub classes).<br>
 *
 * @since 2.0
 */
public abstract class AbstractTransform {

	/**
	 * Specifiy the global opacity to apply on drawing. This opacity is in addition with the opacity encoded in the
	 * pixels of the {@link Image} to draw.<br>
	 * The default opacity is {@link GraphicsContext#OPAQUE}.
	 *
	 * @param alpha
	 *            the opacity
	 */
	public void setAlpha(int alpha) {
		throw new RuntimeException();
	}

	/**
	 * Restore the opacity to its default value ({@link GraphicsContext#OPAQUE}).
	 */
	public void resetAlpha() {
		throw new RuntimeException();
	}

	/**
	 * Returns the current opacity.
	 *
	 * @return the current opacity.
	 */
	public int getAlpha() {
		throw new RuntimeException();
	}

	/**
	 * Apply a vertical mirror on source image before drawing it.
	 *
	 * @param applyMirror
	 *            enable or not vertical mirror.
	 */
	public void setMirror(boolean applyMirror) {
		throw new RuntimeException();
	}

	/**
	 * Returns <code>true</code> if vertical mirror is enabled.
	 *
	 * @return true if vertical mirror is enabled.
	 */
	public boolean isMirrored() {
		throw new RuntimeException();
	}

	/**
	 * Translates the transformation origin with the given vector <code>(x,y)</code>. Subsequent rendering operations on
	 * a {@link GraphicsContext} will be relative to the new origin (in addition of {@link GraphicsContext}'s
	 * translation.
	 *
	 * @param x
	 *            the translation for the x coordinate
	 *
	 * @param y
	 *            the translation for the y coordinate
	 */
	public void translate(int x, int y) {
		throw new RuntimeException();
	}

	/**
	 * Resets translation (<code>(0,0)</code>).
	 */
	public void resetTranslate() {
		throw new RuntimeException();
	}

	/**
	 * Returns the current x translation.
	 *
	 * @return x the current x translation.
	 */
	public int getTranslateX() {
		throw new RuntimeException();
	}

	/**
	 * Returns the current y translation.
	 *
	 * @return y the current y translation.
	 */
	public int getTranslateY() {
		throw new RuntimeException();
	}

}
