/*
 * Java
 *
 * Copyright 2024-2025 MicroEJ Corp. All rights reserved.
 * MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microvg.paint;

/**
 * Color visitor that changes color's opacity.
 */
public class OpacityVisitor implements PaintVisitor {

	private final int alpha;

	/**
	 * Creates an opacity transformer.
	 *
	 * @param alpha
	 *            the opacity to apply
	 */
	public OpacityVisitor(int alpha) {
		this.alpha = alpha;
	}

	@Override
	public int visitColor(int color) {
		return (this.alpha != VGPaint.ALPHA_FULLY_OPAQUE) ? VGPaint.applyOpacity(color, this.alpha) : color;
	}

}
