/*
 * Java
 *
 * Copyright 2022-2025 MicroEJ Corp. All rights reserved.
 * MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microvg.image;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.nio.ByteBuffer;

import ej.microvg.image.pathdata.PathData;
import ej.microvg.paint.LinearGradient;

/**
 * The image decoder "stub": no path is decoded.
 */
public class StubImageDecoder implements ImageDecoder {

	@Override
	public PathData decodePath(ByteBuffer buffer) {
		return new PathData() {

			@Override
			public double nextCoordinate() {
				return 0;
			}

			@Override
			public int nextCommand() {
				return 0;
			}

			@Override
			public boolean hasRemainingCommand() {
				return false;
			}
		};
	}

	@Override
	public LinearGradient decodeGradient(ByteBuffer buffer) {
		return new LinearGradient(new Color[] { new Color(0) }, new float[] { 0 }, new AffineTransform());
	}

	@Override
	public int decodeCommand(int command) {
		return command;
	}

	@Override
	public int decodeFillRule(int rule) {
		return rule;
	}

}
