/*
 * Java
 *
 * Copyright 2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.bluetooth.util;

import ej.util.message.MessageLogger;
import ej.util.message.basic.BasicMessageLogger;

/**
 * Provides constants related to message logging.
 */
/* package */ class Messages {

	/**
	 * Error during advertisement data serialization: max data size reached.
	 */
	public static final int ERROR_MAX_ADVERTISEMENT_DATA_SIZE_REACHED = -1;

	/**
	 * The log category for messages logged by this library.
	 */
	public static final String CATEGORY = "ej.bluetooth.util";

	private Messages() {
		// private constructor
	}

	public static MessageLogger getLogger() {
		MessageLogger logger = BasicMessageLogger.INSTANCE;
		assert (logger != null);
		return logger;
	}
}
