/*
 * Java
 *
 * Copyright 2018-2025 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package com.microej.kf.util;

import ej.kf.Converter;
import ej.kf.Feature;
import ej.kf.Kernel;

/**
 * A {@link Converter} for {@link Boolean}. This converter creates a clone of the original {@link Boolean}.
 */
public class BooleanConverter implements Converter<Boolean> {

	@Override
	public Boolean convert(Boolean arg0, Feature targetOwner) throws IllegalAccessError {
		final boolean value = arg0.booleanValue();
		RunnableWithResult<Boolean> runnable = new RunnableWithResult<Boolean>() {
			@Override
			public Boolean runWithResult() {
				return new Boolean(value);
			}
		};
		Kernel.runUnderContext(targetOwner, runnable);
		return runnable.getResult();
	}

	@Override
	public Class<Boolean> getType() {
		return Boolean.class;
	}

}