/*
 * Java
 *
 * Copyright 2018-2025 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package com.microej.kf.util;

import ej.kf.Converter;
import ej.kf.Feature;
import ej.kf.Kernel;

/**
 * A {@link Converter} for {@link Long}. This converter creates a clone of the original {@link Long}.
 */
public class LongConverter implements Converter<Long> {

	@Override
	public Long convert(Long arg0, Feature targetOwner) throws IllegalAccessError {
		final long value = arg0.longValue();
		RunnableWithResult<Long> runnable = new RunnableWithResult<Long>() {
			@Override
			public Long runWithResult() {
				return new Long(value);
			}
		};
		Kernel.runUnderContext(targetOwner, runnable);
		return runnable.getResult();
	}

	@Override
	public Class<Long> getType() {
		return Long.class;
	}

}