/*
 * Java
 *
 * 2013-2022 ESR - Not subject to Copyright.
 *
 * This document has been released and published by E-S-R consortium, a non-profit entity.
 * To learn more about E-S-R consortium, please visit http://www.e-s-r.net/.
 * The matter contained in this document is not subject to copyright; you are free to use it for any purpose, for more information see E-S-R consortium policies.
 */
package ej.kf;

/**
 * Each Feature shall define one entry point that implements this interface. Methods are called by the Kernel.
 */
public interface FeatureEntryPoint {

	/**
	 * This method is called once by the Kernel when a Feature has been newly started.
	 * It is executed in a dedicated thread owned by the Feature, so it may consider it as its "main" thread.
	 * This allows a Feature to connect to the application (by adding new Feature points, services, ...)
	 */
	public void start();

	/**
	 * This method is called once by the Kernel when a Feature is going to be unloaded.
	 * It is executed in a dedicated thread owned by the Feature.
	 * Feature is responsible to do its best effort to properly stop threads and close resources it has created as soon as possible.
	 */
	public void stop();

}
