package ej.ecom;

import java.util.Iterator;

/**
 * The {@link DeviceManager} holds the {@link Device} registry. It allows to register, unregister, list devices.
 * Registered {@link RegistrationListener} are notified when a device is registered or unregistered.
 */
public class DeviceManager {

	private DeviceManager(){}
	
	/**
	 * Adds the given {@link RegistrationListener} to be notified when a device of the given type is registered or unregistered.
	 * If there is a security manager, its {@link SecurityManager#checkPermission(java.security.Permission)} method is called with the {@link DeviceManagerPermission#READ} name and the device type.
	 * The listener may be registered multiple times on different device types.
	 * @param <D> the type of the devices to be listened for
	 * @param listener the registration listener
	 * @param deviceType the type of the devices to be listened for
	 * @throws SecurityException if a security manager exists and it does not allow the caller to listen to devices registered with the given type
	 */
	public static <D extends Device> void addRegistrationListener(RegistrationListener<D> listener, Class<D> deviceType){
		throw new RuntimeException();
	}
	
	/**
	 * Removes the given {@link RegistrationListener} from the list of listeners that are notified when a device is registered or unregistered. 
	 * The listener may have been registered multiple times on different device types.
	 * @param <D> the type of the device listened for
	 * @param listener the registration listener
	 */
	public static <D extends Device> void removeRegistrationListener(RegistrationListener<D> listener){
		throw new RuntimeException();
	}
	
	/**
	 * Registers a new device with the given type. 
	 * If there is a security manager, its {@link SecurityManager#checkPermission(java.security.Permission)} method is called with {@link DeviceManagerPermission#MODIFY} name and the device type.
	 * @param <D> the type of the device to be registered
	 * @param deviceType the type of the device to be registered
	 * @param device the device to be registered
	 * @throws SecurityException if a security manager exists and it does not allow the caller to register a device with the given type.
	 * @throws IllegalArgumentException if the device has already been registered
	 */
	public static <D extends Device> void register(Class<D> deviceType, D device){
		throw new RuntimeException();
	}
	
	/**
	 * Unregisters the given device.
	 * If there is a security manager, its {@link SecurityManager#checkPermission(java.security.Permission)} method is called with {@link DeviceManagerPermission#MODIFY} name and the device type on which it has been registered.
	 * Some devices are registered by the underlying platform and cannot be unregistered.
	 * @param device the device to be unregistered
	 * @throws SecurityException if a security manager exists and it does not allow the caller to unregister a device
	 */
	public static void unregister(Device device){
		throw new RuntimeException();
	}
	
	/**
	 * List all registered devices.
	 * If there is a security manager, its {@link SecurityManager#checkPermission(java.security.Permission)} method is called with {@link DeviceManagerPermission#READ} name and the {@link Device} class.
	 * This is equivalent to:
	 * <pre>list(Device.class)</pre>
	 * @return an iterator of all registered devices.
	 * @throws SecurityException if a security manager exists and it doesn't allow the caller to list devices
	 */
	public static Iterator<Device> list(){
		throw new RuntimeException();
	}
	
	/**
	 * List all registered devices such as the given type is assignable from the device class.
	 * If there is a security manager, its {@link SecurityManager#checkPermission(java.security.Permission)} method is called with {@link DeviceManagerPermission#READ} action and the device type.
	 * @param <D> the type of devices to list
	 * @param deviceType the type of the device to be registered
	 * @return an iterator of all registered devices of the given type
	 * @throws SecurityException if a security manager exists and it doesn't allow the caller to list devices of the given type
	 */
	public static <D extends Device> Iterator<D> list(Class<D> deviceType){
		throw new RuntimeException();
	}
		
}
