/*
 * Java
 *
 * Copyright 2017 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.rcommand.synchronous;

import java.io.IOException;

import ej.rcommand.CommandReader;
import ej.rcommand.CommandSender;
import ej.rcommand.RemoteCommandListener;

/**
 * Endpoint adapter.
 */
public class EndpointListener implements RemoteCommandListener {

	private static final String COMMAND_RESPONSE_SUFFIX = "_response";

	private final Endpoint endpoint;

	public EndpointListener(Endpoint endpoint) {
		this.endpoint = endpoint;
	}

	@Override
	public String[] getManagedCommands() {
		return new String[] { this.endpoint.getName() };
	}

	@Override
	public void commandReceived(CommandReader commandReader, CommandSender commandSender, String command) {
		try {
			int commandId = commandReader.readInt();
			this.endpoint.readRequestBody(commandReader);
			commandSender.startCommand(command + COMMAND_RESPONSE_SUFFIX);
			commandSender.sendInt(commandId);
			this.endpoint.writeResponseBody(commandSender);
			commandSender.flushCommand();
		} catch (IOException e) {
			// Ignored.
		}
	}

}
