/*
 * Java
 *
 * Copyright 2019-2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.bluetooth;

/**
 * The <code>BluetoothDataTypes</code> class enumerates the values for advertising data types.
 * <p>
 * Refer to «Core Specification Supplement Part A, 1 Data Types Definitions and Formats».
 */
public class BluetoothDataTypes {

	/** Flags. */
	public static final byte FLAGS = 0x01;

	/** Incomplete List of 16-bit Service UUIDs. */
	public static final byte SERVICE_UUID16_INCOMPLETE_LIST = 0x02;
	/** Complete List of 16-bit Service UUIDs. */
	public static final byte SERVICE_UUID16_COMPLETE_LIST = 0x03;
	/** Incomplete List of 32-bit Service UUIDs. */
	public static final byte SERVICE_UUID32_INCOMPLETE_LIST = 0x04;
	/** Complete List of 32-bit Service UUIDs. */
	public static final byte SERVICE_UUID32_COMPLETE_LIST = 0x05;
	/** Incomplete List of 128-bit Service UUIDs. */
	public static final byte SERVICE_UUID128_INCOMPLETE_LIST = 0x06;
	/** Complete List of 128-bit Service UUIDs. */
	public static final byte SERVICE_UUID128_COMPLETE_LIST = 0x07;

	/** Shortened Local Name. */
	public static final byte SHORTENED_LOCAL_NAME = 0x08;
	/** Complete Local Name. */
	public static final byte COMPLETE_LOCAL_NAME = 0x09;

	/** TX Power Level. */
	public static final byte TX_POWER_LEVEL = 0x0A;

	/** Slave Connection Interval Range. */
	public static final byte SLAVE_CONNECTION_INTERVAL_RANGE = 0x12;

	/** List of 16 bit Service Solicitation UUIDs. */
	public static final byte SERVICE_SOLICITATION_UUID16_LIST = 0x14;
	/** List of 32 bit Service Solicitation UUIDs. */
	public static final byte SERVICE_SOLICITATION_UUID32_LIST = 0x1F;
	/** List of 128 bit Service Solicitation UUIDs. */
	public static final byte SERVICE_SOLICITATION_UUID128_LIST = 0x15;

	/** Service Data - 16 bit UUID. */
	public static final byte SERVICE_DATA_UUID16 = 0x16;
	/** Service Data - 32 bit UUID. */
	public static final byte SERVICE_DATA_UUID32 = 0x20;
	/** Service Data - 128 bit UUID. */
	public static final byte SERVICE_DATA_UUID128 = 0x21;

	/** Public Target Address. */
	public static final byte PUBLIC_TARGET_ADDRESS = 0x17;
	/** Random Target Address. */
	public static final byte RANDOM_TARGET_ADDRESS = 0x18;

	/** Appearance. */
	public static final byte APPEARANCE = 0x19;

	/** Advertising Interval. */
	public static final byte ADVERTISING_INTERVAL = 0x1A;

	/** URI. */
	public static final byte URI = 0x24;

	/** LE Supported Features. */
	public static final byte LE_SUPPORTED_FEATURES = 0x27;

	/** Manufacturer Specific Data. */
	public static final byte MANUFACTURER_SPECIFIC_DATA = (byte) 0xFF;

	/**
	 * Private constructor.
	 */
	private BluetoothDataTypes() {
		throw new RuntimeException();
	}
}
