/*
 * Java
 *
 * Copyright 2011-2015 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.bon;

import java.util.Date;

/**
 * This class offers basic services for B-ON implementation.
 */
public class Util {

	/**
	 * Indicates whether the system has entered the mission phase, i.e. it is initialized.
	 *
	 * @see Immortals
	 * @return <code>true</code> if the initialization is done
	 */
	public static boolean isInMission(){
		throw new RuntimeException();
	}

	/**
	 * Indicates whether the current code is part of the initialization phase.<p>
	 * When {@link java.lang.Class#forName(String)} triggers classes to be loaded at runtime
	 * dynamically, class initializations are done in a context where {@link #isInInitialization} is
	 * <code>true</code> and {@link #isInMission} is <code>true</code>.
	 *
	 * @see Immortals
	 * @return <code>true</code> if the initialization is ongoing
	 */
	public static boolean isInInitialization(){
		throw new RuntimeException();
	}

	/**
	 * Tests the ability of the system to download code through
	 * {@link java.lang.Class#forName(String)}
	 *
	 * @return <code>true</code> if the system allows dynamic code to be loaded, <code>false</code>
	 *         otherwise
	 */
	public static boolean dynamicCodeAllowed(){
		throw new RuntimeException();
	}

	/**
	 * Throws an exception in a specified thread.<p>
	 * <ul>
	 * <li>If the thread is either sleeping or waiting, the thread is unblocked and the exception is
	 * thrown as soon as possible.</li>
	 * <li>If the thread is running, the exception is thrown just as if a throw statement was the
	 * next instruction to execute.</li>
	 * <li>If the thread is not started yet or is terminated, nothing is done.</li>
	 * <li>If the thread has entered one or more critical sections (i.e. it holds some object's
	 * monitor) the exception is not thrown until the thread has exited all the critical sections.</li>
	 * <li>If an exception thrown via {@link #throwExceptionInThread(RuntimeException, Thread)} or {@link #throwHardExceptionInThread(RuntimeException, Thread)} is already pending for the thread, nothing is done.</li>
	 * </ul>
	 * <br>
	 * If any of the arguments is <code>null</code>, an <code>IllegalArgumentException</code> is
	 * thrown.
	 *
	 * @param e
	 *            the exception to throw
	 * @param t
	 *            the thread in which the exception is thrown
	 * @throws IllegalArgumentException
	 *             if any of the arguments is <code>null</code>.
	 */
	public static void throwExceptionInThread(RuntimeException e, Thread t){
		throw new RuntimeException();
	}

	/**
	 * Throws an exception in a specified thread.<p>
	 * <ul>
	 * <li>If the thread is either sleeping or waiting, the thread is unblocked and the exception is
	 * thrown as soon as possible.</li>
	 * <li>If the thread is running, the exception is thrown just as if a throw statement was the
	 * next instruction to execute.</li>
	 * <li>If the thread is not started yet or is terminated, nothing is done.</li>
	 * <li>If the thread has entered one or more critical sections, it does not wait the critical
	 * sections to finish and the exception is thrown as soon as possible.</li>
	 * <li>If an exception thrown via {@link #throwHardExceptionInThread(RuntimeException, Thread)} is already pending for the thread, nothing is done.</li>
	 * <li>If an exception thrown via {@link #throwExceptionInThread(RuntimeException, Thread)} is already pending for the thread, this exception is replaced by the
	 * given exception.</li>
	 * </ul>
	 * <br>
	 *
	 * @param e
	 *            the exception to throw
	 * @param t
	 *            the thread in which the exception is thrown
	 * @throws IllegalArgumentException
	 *             if any of the arguments is <code>null</code>.
	 */
	public static void throwHardExceptionInThread(RuntimeException e, Thread t) {
		throw new RuntimeException();
	}

	/**
	 * <p>
	 * Gets the application time in milliseconds.
	 * </p>
	 * <p>
	 * The result of this method is the same as the {@link System#currentTimeMillis()} method one.
	 * </p>
	 *
	 * @return the application time in milliseconds
	 */
	public static long currentTimeMillis(){
		throw new RuntimeException();
	}

	/**
	 * <p>
	 * Gets an arbitrary time in milliseconds.
	 * </p>
	 * <p>
	 * Only elapsed time between two calls is meaningful.
	 * </p>
	 *
	 * @return the platform time in milliseconds
	 */
	public static long platformTimeMillis(){
		throw new RuntimeException();
	}

	/**
	 * <p>
	 * Gets an arbitrary time in nanoseconds.
	 * </p>
	 * <p>
	 * Only elapsed time between two calls is meaningful.
	 * </p>
	 *
	 * @return the platform time in nanoseconds
	 */
	public static long platformTimeNanos(){
		throw new RuntimeException();
	}


	/**
	 * <p>
	 * Sets the application time.
	 * </p>
	 * <p>
	 * This time does not change the platform time.
	 * </p>
	 *
	 * @param t the application time to set in milliseconds
	 * 
	 * @throws IllegalArgumentException if <code>t</code> is negative
	 */
	public static void setCurrentTimeMillis(long t){
		throw new RuntimeException();
	}

	/**
	 * <p>
	 * Sets the application time.
	 * </p>
	 * <p>
	 * This time does not change the platform time.
	 * The <code>Util.setCurrentTimeMillis(d)</code> method has the same effect as <code>Util.setCurrentTimeMillis(d.getTime())</code>.
	 * </p>
	 *
	 * @param d the application time to set
	 */
	public static void setCurrentTimeMillis(Date d){
		throw new RuntimeException();
	}

}