/*
 * Java
 *
 * Copyright 2018-2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.util.message;

/**
 * A message builder builds simple messages based on integer IDs to avoid using Strings.
 */
public interface MessageBuilder {

	/**
	 * Builds a message.
	 *
	 * @param level
	 *            the level of the message.
	 * @param category
	 *            the category of the message.
	 * @param id
	 *            the ID of the message.
	 * @return a message.
	 * @throws NullPointerException
	 *             if the given category is <code>null</code>.
	 */
	String buildMessage(char level, String category, int id);

	/**
	 * Builds a message with a throwable.
	 *
	 * @param level
	 *            the level of the message.
	 * @param category
	 *            the category of the message.
	 * @param id
	 *            the ID of the message.
	 * @param t
	 *            the throwable.
	 * @return a message.
	 * @throws NullPointerException
	 *             if the given category is <code>null</code>.
	 */
	String buildMessage(char level, String category, int id, Throwable t);

	/**
	 * Builds a message with arguments.
	 *
	 * @param level
	 *            the level of the message.
	 * @param category
	 *            the category of the message.
	 * @param id
	 *            the ID of the message.
	 * @param arguments
	 *            the arguments.
	 * @return a message.
	 * @throws NullPointerException
	 *             if the given category is <code>null</code>.
	 */
	String buildMessage(char level, String category, int id, Object... arguments);

	/**
	 * Builds a message with a throwable and arguments.
	 *
	 * @param level
	 *            the level of the message.
	 * @param category
	 *            the category of the message.
	 * @param id
	 *            the ID of the message.
	 * @param t
	 *            the throwable.
	 * @param arguments
	 *            the arguments.
	 * @return a message.
	 * @throws NullPointerException
	 *             if the given category is <code>null</code>.
	 */
	String buildMessage(char level, String category, int id, Throwable t, Object... arguments);

}
