/*
 * Copyright 2010-2015 http://beders.github.com/Resty
 * Copyright 2015-2019 MicroEJ Corp. This file has been modified by MicroEJ Corp.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ej.rest.web;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URLConnection;

/**
 * Wrapper for content to be sent as form-data.
 * It adds a specific content-disposition header.
 * Also supports an optional file name;
 * @author beders
 *
 */
public class FormData extends AbstractContent {
	private final AbstractContent wrappedContent;
	private final String controlName;
	private String fileName;

	public FormData(String aControlName, AbstractContent content) {
		controlName = aControlName;
		wrappedContent = content;
		/** if (content instanceof FileContent) { fileName = ...} */
	}

	public FormData(String aControlName, String aFileName, AbstractContent content) {
		this(aControlName, content);
		fileName = aFileName;
	}

	/* (non-Javadoc)
	 * @see us.monoid.web.AbstractContent#addContent(java.net.URLConnection)
	 */
	@Override
	protected void addContent(URLConnection con) throws IOException {
		throw new IOException("This content must be sent as part of a MultipartContent");
	}

	/* (non-Javadoc)
	 * @see us.monoid.web.AbstractContent#writeContent(java.io.OutputStream)
	 */
	@Override
	public void writeContent(OutputStream os) throws IOException {
		wrappedContent.writeContent(os);
	}

	/* (non-Javadoc)
	 * @see us.monoid.web.AbstractContent#writeHeader(java.io.OutputStream)
	 */
	@Override
	public void writeHeader(OutputStream os) throws IOException {
		//assuming controlName is ASCII
		os.write(ascii("Content-Disposition: form-data; name=\"" + enc(controlName)
				+ "\"" +
				((fileName != null) ? "; filename=\"" + enc(fileName) + "\"" : "") + "\r\n"));
		wrappedContent.writeHeader(os);
	}


}
