/*
 * Copyright 2010-2015 http://beders.github.com/Resty
 * Copyright 2015-2019 MicroEJ Corp. This file has been modified by MicroEJ Corp.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ej.rest.web;

/**
 * All-purpose resource which is used to access application/octet-stream content or any content in that respect.
 * I.e. it will match all types, so you can also download raw JSON or images or whatever media type you envision.
 * @author beders
 *
 */
public class BinaryResource extends AbstractResource {

	public BinaryResource(Option... options) {
		super(options);
	}

	/* (non-Javadoc)
	 * @see us.monoid.web.AbstractResource#getAcceptedTypes()
	 */
	@Override
	public String getAcceptedTypes() {
		return "application/octet-stream,*/*";
	}

	/** Save the contents of the resource to a file.
	 * This reads the data from the stream and stores it into the given file.
	 * Depending on the resource the data might or might not be available afterwards.
	 * 
	 * @param aFileName file to save the data in
	 * @return the file the content was stored at
	 * @throws IOException
	 */
	/*
	public File save(File aFileName) throws IOException {
		BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(aFileName), 1024);
		byte[] buffer = new byte[1024];
		int len = -1;
		while ((len = inputStream.read(buffer)) != -1) {
			bos.write(buffer, 0, len);
		}
		bos.close();
		inputStream.close();
		return aFileName;
	}
	 */


}
