/*
 * Copyright 2010-2015 http://beders.github.com/Resty
 * Copyright 2015-2019 MicroEJ Corp. This file has been modified by MicroEJ Corp.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ej.rest.web;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLConnection;
import java.net.URLEncoder;

/**
 * Abstract base class of the content being sent to a server.
 * Check Resty.content(...) methods to create objects
 * @author beders
 *
 */
public abstract class AbstractContent {
	public static final byte[] CRLF = { '\r', '\n' };

	abstract public void writeHeader(OutputStream os) throws IOException;
	abstract public void writeContent(OutputStream os) throws IOException;
	abstract protected void addContent(URLConnection con) throws IOException;

	protected byte[] ascii(String string) {
		try {
			return string.getBytes("US-ASCII");
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}

		return null;
	}

	protected String enc(String aString) {
		try {
			return URLEncoder.encode(aString, "UTF-8");
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}

		return null;
	}
}
