/*
 * Java
 *
 * Copyright 2015-2019 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.util.concurrent;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SingleThreadExecutor implements Runnable, ExecutorService {
	private final Thread thread;
	private final Queue<Runnable> tasks;
	private boolean terminated;

	public SingleThreadExecutor() {
		this.thread = new Thread(this, SingleThreadExecutor.class.getName());
		this.tasks = new ArrayDeque<Runnable>();
		this.thread.start();
	}

	@Override
	public void run() {
		while (!this.thread.isInterrupted()) {
			Runnable active;
			synchronized (this.tasks) {
				active = this.tasks.poll();
				if (active == null) {
					try {
						this.tasks.wait();
					} catch (InterruptedException e) {
						// stop execution?
						this.terminated = true;
						return;
					}
				}
			}
			if (active != null) {
				active.run();
			}
		}
		this.terminated = true;
	}

	@Override
	public void execute(final Runnable r) {
		synchronized (this.tasks) {
			this.tasks.offer(r);
			this.tasks.notify();
		}
	}

	@Override
	public void shutdown() {
		this.thread.interrupt();
	}

	@Override
	public List<Runnable> shutdownNow() {
		throw new UnsupportedOperationException();
	}

	@Override
	public boolean isShutdown() {
		return this.terminated;
	}

	@Override
	public boolean isTerminated() {
		return this.terminated;
	}

	@Override
	public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
		throw new UnsupportedOperationException();
	}

	@Override
	public <T> Future<T> submit(Callable<T> task) {
		throw new UnsupportedOperationException();
	}

	@Override
	public <T> Future<T> submit(Runnable task, T result) {
		throw new UnsupportedOperationException();
	}

	@Override
	public Future<?> submit(Runnable task) {
		throw new UnsupportedOperationException();
	}

	@Override
	public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
		throw new UnsupportedOperationException();
	}

	@Override
	public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit)
			throws InterruptedException {
		throw new UnsupportedOperationException();
	}

	@Override
	public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
		throw new UnsupportedOperationException();
	}

	@Override
	public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit)
			throws InterruptedException, ExecutionException, TimeoutException {
		throw new UnsupportedOperationException();
	}

}