/*
 * Copyright 2016-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.mwt.style.background;

import ej.annotation.Nullable;
import ej.microui.display.GraphicsContext;

/**
 * Represents the background of the widgets.
 */
public interface Background {

	/**
	 * Tells whether or not this background is transparent.
	 * <p>
	 * A background is considered as transparent if it does not draw every pixel with maximal opacity when it is
	 * applied. If a widget has a transparent background, its parent has to be rendered before the widget.
	 *
	 * @param width
	 *            the width of the background.
	 * @param height
	 *            the height of the background.
	 * @return <code>true</code> if the background is transparent, <code>false</code> otherwise.
	 */
	boolean isTransparent(int width, int height);

	/**
	 * Applies the background on a graphics context.
	 *
	 * @param g
	 *            the graphics context.
	 * @param width
	 *            the width of the background.
	 * @param height
	 *            the height of the background.
	 */
	void apply(GraphicsContext g, int width, int height);

	@Override
	boolean equals(@Nullable Object obj);

	@Override
	int hashCode();
}
