/*
 * Java
 *
 * Copyright 2017-2025 MicroEJ Corp. All rights reserved.
 * MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.sni;


/**
 * {@link RuntimeException} subclass that may be thrown from an SNI native using
 * <code>SNI_throwNativeException()</code> function.
 */
public class NativeException extends RuntimeException {

	private final int errorCode;

	/**
	 * Constructs a new {@link NativeException} with the specified error code and
	 * detail message.
	 *
	 * @param errorCode
	 *            the error code. The error code is saved for later retrieval by the
	 *            {@link #getErrorCode()} method.
	 *
	 * @param errorMessage
	 *            the detail message. The detail message is saved for later
	 *            retrieval by the {@link #getMessage()} method.
	 */
	public NativeException(int errorCode, String errorMessage) {
		super(errorMessage);
		this.errorCode = errorCode;
	}

	/**
	 * Constructs a new {@link NativeException} with the specified error code,
	 * detail message and cause.
	 *
	 * @param errorCode
	 *            the error code. The error code is saved for later retrieval by the
	 *            {@link #getErrorCode()} method.
	 *
	 * @param errorMessage
	 *            the detail message. The detail message is saved for later
	 *            retrieval by the {@link #getMessage()} method.
	 *
	 * @param cause
	 *            the cause (which is saved for later retrieval by the
	 *            {@link #getCause()} method). (A <tt>null</tt> value is permitted,
	 *            and indicates that the cause is nonexistent or unknown.)
	 */
	public NativeException(int errorCode, String errorMessage, Throwable cause) {
		super(errorMessage, cause);
		this.errorCode = errorCode;
	}

	/**
	 * Returns the error code of this {@link NativeException}.
	 * 
	 * @return the error code of this {@link NativeException} instance.
	 */
	public int getErrorCode() {
		return errorCode;
	}

}
