/*
 * Copyright 2015-2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.mwt.style.background;

import ej.annotation.Nullable;
import ej.microui.display.GraphicsContext;
import ej.microui.display.Painter;

/**
 * Draws a plain color on the background with a rectangular border.
 */
public class RectangularBackground implements Background {

	private final int color;

	/**
	 * Creates a rectangular background with no border.
	 *
	 * @param color
	 *            the color.
	 */
	public RectangularBackground(int color) {
		this.color = color;
	}

	/**
	 * Gets the color.
	 *
	 * @return the color.
	 */
	public int getColor() {
		return this.color;
	}

	@Override
	public boolean isTransparent(int width, int height) {
		return false;
	}

	@Override
	public void apply(GraphicsContext g, int width, int height) {
		g.setColor(this.color);
		Painter.fillRectangle(g, 0, 0, width, height);

		// Set background color to optimize future anti-aliased drawings.
		g.setBackgroundColor(this.color);
	}

	@Override
	public boolean equals(@Nullable Object obj) {
		if (obj != null && getClass() == obj.getClass()) {
			RectangularBackground background = (RectangularBackground) obj;
			return this.color == background.color;
		}
		return false;
	}

	@Override
	public int hashCode() {
		return this.color;
	}
}
