/*
 * Java
 *
 * Copyright 2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.hoka.http;

import java.util.ArrayList;
import java.util.List;

/**
 *
 */
class MethodNotAllowedException extends RuntimeException {

	private static final long serialVersionUID = 1L;

	private final List<Route> allowedRoutes;

	/**
	 * @param possibleRoutes
	 *            route that match the request
	 */
	MethodNotAllowedException(List<Route> possibleRoutes) {
		super();
		this.allowedRoutes = new ArrayList<>(possibleRoutes);
	}

	protected String getAllowHeader() {
		StringBuilder allow = new StringBuilder();
		boolean addComa = false;
		for (Route r : this.allowedRoutes) {
			if (addComa) {
				allow.append(", "); //$NON-NLS-1$
			}
			allow.append(r.getHttpMethodAsString());
			addComa = true;
		}

		return allow.toString();
	}

}
