/*
 * Copyright 2018 IS2T. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break IS2T warranties on the whole library.
 */
package ej.property;

import ej.annotation.Nullable;

/**
 * A property registry is a property loader that allows to add or remove properties dynamically.
 */
public interface PropertyRegistry extends PropertyLoader {

	/**
	 * Sets a property that maps a key to a value.
	 *
	 * @param key
	 *            the key.
	 * @param value
	 *            the value.
	 * @return the previous value of the property, or <code>null</code> if the property is not found.
	 * @throws SecurityException
	 *             if a security manager exists and does not allow the caller to set the given property.
	 */
	@Nullable
	String setProperty(String key, String value);

	/**
	 * Removes a property.
	 *
	 * @param key
	 *            the key.
	 * @return the value of the property, or <code>null</code> if the property is not found.
	 * @throws SecurityException
	 *             if a security manager exists and does not allow the caller to remove the given property.
	 */
	@Nullable
	String removeProperty(String key);

}
