/*
 * Copyright 2016-2019 IS2T. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break IS2T warranties on the whole library.
 */
package ej.property;

import ej.annotation.Nullable;

/**
 * A property loader is a map of properties. The keys and their corresponding values are strings.
 */
public interface PropertyLoader {

	/**
	 * Gets the value mapped with the specified key.
	 *
	 * @param key
	 *            the key.
	 * @return the value of the property, or <code>null</code> if the property is not found.
	 * @throws SecurityException
	 *             if a security manager exists and does not allow the caller to retrieve the given property.
	 */
	@Nullable
	String getProperty(String key);

	/**
	 * Gets the value mapped with the specified key or a default value.
	 *
	 * @param key
	 *            the key.
	 * @param defaultValue
	 *            the default value.
	 * @return the value of the property, or the default value if the property is not found.
	 * @throws SecurityException
	 *             if a security manager exists and does not allow the caller to retrieve the given property.
	 */
	String getProperty(String key, String defaultValue);
}
