/*
 * Copyright 2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package com.microej.wear.services;

import com.microej.wear.components.Activity;
import com.microej.wear.components.ComplicationDataSource;
import com.microej.wear.components.Watchface;

/**
 * This service allows Features to register activities, watchfaces and complication data sources.
 */
public interface ComponentService {

	/**
	 * Registers the given activity.
	 *
	 * @param activity
	 *            the activity to register.
	 */
	void registerActivity(Activity activity);

	/**
	 * Registers the given watchface.
	 *
	 * @param watchface
	 *            the watchface to register.
	 */
	void registerWatchface(Watchface watchface);

	/**
	 * Registers the given complication data source.
	 *
	 * @param source
	 *            the source to register.
	 */
	void registerComplicationDataSource(ComplicationDataSource source);

	/**
	 * Returns an array containing all the complication data sources.
	 *
	 * @return an array containing all the complication data sources.
	 */
	ComplicationDataSource[] getComplicationDataSources();
}
