/*
 * Java
 *
 * Copyright 2014-2015 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.rcommand.impl;

import ej.rcommand.CommandSenderProvider;
import ej.rcommand.RemoteService;

abstract public class AbstractRemoteService implements RemoteService {

	/** Null until this service is initialized. */
	protected CommandSenderProvider commandSenderProvider;

	/**
	 * This method must be called before registering or using this service.
	 */
	@Override
	public void initialize(CommandSenderProvider connectionProvider) {
		this.commandSenderProvider = connectionProvider;
	}

	@Override
	public void start() {
		// By default, does nothing
	}

	@Override
	public void stop() {
		// By default, does nothing
	}
}
