/*
 * Copyright (c) 2003, 2013, Oracle and/or its affiliates. All rights reserved.
 * Copyright 2021-2022 MicroEJ Corp. This file has been modified by MicroEJ Corp.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 */
package java.security.spec;

import ej.annotation.Nullable;

/**
 * This immutable class specifies the set of parameters used for generating elliptic curve (EC) domain parameters.
 *
 * @see AlgorithmParameterSpec
 *
 * @author Valerie Peng
 *
 * @since 1.5
 */
public class ECGenParameterSpec implements AlgorithmParameterSpec {

	/**
	 * Creates a parameter specification for EC parameter generation using a standard (or predefined) name
	 * {@code stdName} in order to generate the corresponding (precomputed) elliptic curve domain parameters. For the
	 * list of supported names, please consult the documentation of provider whose implementation will be used.
	 *
	 * @param stdName
	 *            the standard name of the to-be-generated EC domain parameters.
	 * @exception NullPointerException
	 *                if {@code stdName} is null.
	 */
	public ECGenParameterSpec(@Nullable String stdName) {
		throw new RuntimeException();
	}

	/**
	 * Returns the standard or predefined name of the to-be-generated EC domain parameters.
	 *
	 * @return the standard or predefined name.
	 */
	public String getName() {
		throw new RuntimeException();
	}
}
