package java.lang;

import java.io.Serializable;

import ej.annotation.Nullable;

/**
 * This is the common base class of all Java language enumeration types.
 *
 * More information about enums, including descriptions of the implicitly declared methods
 * synthesized by the compiler, can be found in section 8.9 of <cite>The Java&trade; Language
 * Specification</cite>.
 *
 * @param <E>
 *        The enum type subclass
 */
public abstract class Enum<E extends Enum<E>> implements Comparable<E>, Serializable {

	/**
	 * This method is available for compilation purpose.
	 * @param enumType the Class object of the enum type from which to return a constant
	 * @param name the name of the constant to return
	 * @return the enum constant of the specified enum type with the specified name
	 *
	 * @throws NoSuchMethodError
	 *         always
	 * @param <T> the enum type whose constant is to be returned        
	 */
	public static <T extends Enum<T>> T valueOf(Class<T> enumType, String name) {
		throw new RuntimeException();
	}

	/**
	 * Sole constructor. Programmers cannot invoke this constructor. It is for use by code emitted by
	 * the compiler in response to enum type declarations.
	 *
	 * @param name
	 *        - The name of this enum constant, which is the identifier used to declare it.
	 * @param ordinal
	 *        - The ordinal of this enumeration constant (its position in the enum declaration, where
	 *        the initial constant is assigned an ordinal of zero).
	 */
	protected Enum(String name, int ordinal) {
		throw new RuntimeException();
	}

	/**
	 * Compares this enum with the specified object for order. Returns a negative integer, zero, or a
	 * positive integer as this object is less than, equal to, or greater than the specified object.
	 *
	 * Enum constants are only comparable to other enum constants of the same enum type. The natural
	 * order implemented by this method is the order in which the constants are declared.
	 */
	@Override
	public final int compareTo(E o) {
		throw new RuntimeException();
	}

	/**
	 * Returns true if the specified object is equal to this enum constant.
	 *
	 * @param other
	 *        the object to be compared for equality with this object.
	 * @return true if the specified object is equal to this enum constant.
	 */
	@Override
	public final boolean equals(@Nullable Object other) {
		throw new RuntimeException();
	}

	/**
	 * Returns a hash code for this enum constant.
	 *
	 * @return a hash code for this enum constant.
	 */
	@Override
	public final int hashCode() {
		throw new RuntimeException();
	}

	/**
	 * Returns the name of this enum constant, exactly as declared in its enum declaration.
	 *
	 * <b>Most programmers should use the {@link #toString} method in preference to this one, as the
	 * toString method may return a more user-friendly name.</b> This method is designed primarily for
	 * use in specialized situations where correctness depends on getting the exact name, which will not
	 * vary from release to release.
	 *
	 * @return the name of this enum constant
	 */
	public final String name() {
		throw new RuntimeException();
	}

	/**
	 * Returns the ordinal of this enumeration constant (its position in its enum declaration, where the
	 * initial constant is assigned an ordinal of zero).
	 *
	 * @return the ordinal of this enumeration constant
	 */
	public final int ordinal() {
		throw new RuntimeException();
	}

	/**
	 * Returns the name of this enum constant, as contained in the declaration. This method may be
	 * overridden, though it typically isn't necessary or desirable. An enum type should override this
	 * method when a more "programmer-friendly" string form exists.
	 *
	 * @return the name of this enum constant
	 */
	@Override
	public String toString() {
		throw new RuntimeException();
	}

}
