/*
 * Java
 *
 * Copyright 2018 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.bluetooth;

/**
 * The <code>BluetoothProperties</code> interface enumerates the values for characteristic properties.
 * <p>
 * Multiple flags may be combined to create a set of properties.
 * <p>
 * Characteristic properties are not used to control access to the characteristic. The properties are only used as an
 * indication to the client on how this characteristic may be used.
 * <p>
 * Refer to «Core Vol 3, Part G, 3.3.1.1 Characteristic Properties».
 */
public interface BluetoothProperties {

	/** No property. */
	int NONE = 0x00;

	/** Indicates that the characteristic value may be broadcasted in advertising data. */
	int BROADCAST = 0x01;

	/** Indicates that the characteristic value may be read. */
	int READ = 0x02;

	/** Indicates that the characteristic value may be written (using write without response procedure). */
	int WRITE_NO_RESPONSE = 0x04;

	/** Indicates that the characteristic value may be written. */
	int WRITE = 0x08;

	/** Indicates that the characteristic supports notifications. */
	int NOTIFY = 0x10;

	/** Indicates that the characteristic supports indications. */
	int INDICATE = 0x20;

	/** Indicates that the characteristic value may be written (using signed write procedure). */
	int WRITE_SIGNED = 0x40;

	/** Indicates that additional properties are defined in the Characteristic Extended Properties descriptor. */
	int EXTENDED = 0x80;
}
