/*
 * Java
 *
 * Copyright 2015-2019 MicroEJ Corp. All rights reserved.
 * MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microui.display;

import java.security.Permission;

import ej.annotation.Nullable;

/**
 * Permission to access a Display. Permission is checked when calling {@link Displayable#show()}.
 *
 * @since 2.0
 */
public class DisplayPermission extends Permission {

	/**
	 * Creates a display permission for the given display with <code>null</code> as name.
	 *
	 * @param display
	 *            the display.
	 */
	public DisplayPermission(@Nullable Display display) {
		super(null);
		throw new RuntimeException();
	}

	/**
	 * Gets the display handled by this permission.
	 *
	 * @return the display.
	 */
	public Display getDisplay() {
		throw new RuntimeException();
	}

	@Override
	public boolean equals(@Nullable Object obj) {
		throw new RuntimeException();
	}

	@Override
	public String getActions() {
		throw new RuntimeException();
	}

	@Override
	public int hashCode() {
		throw new RuntimeException();
	}

	@Override
	public boolean implies(Permission permission) {
		throw new RuntimeException();
	}
}
