/*
 * Java
 *
 * Copyright 2016 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.tool.addon;

import java.io.File;
import java.util.List;

/**
 * A Java project represents a view of a project resource in terms of Java elements such as project root folder, Ivy
 * module, source folders and classpath.
 */
public interface JavaProject {

	/**
	 * Gets this project root folder.
	 *
	 * @return a pathname that denotes the project root folder. This method always returns a valid folder.
	 */
	File getProjectFolder();

	/**
	 * Gets the path to the project Ivy module file.
	 *
	 * @return the path to the project Ivy module file. This method always returns a valid file.
	 */
	File getIvyModule();

	/**
	 * Gets project folders of the given kinds.
	 *
	 * @param kinds
	 *            all kinds of folder to get.
	 * @return a possibly empty list of folders that match given kinds.
	 */
	List<File> getFolders(FolderKind... kinds);

	/**
	 * Gets if the given folder is of the given kind.
	 *
	 * @param folder
	 *            the folder to test.
	 * @param kind
	 *            the kind of folder.
	 * @return {@code true} if folder is of the given kind, {@code false} otherwise.
	 */
	boolean isFolderKind(File folder, FolderKind kind);

	/**
	 * Gets this project classpath.
	 *
	 * <p>
	 * Instances of {@link File} that denote file paths are JAR files, and instances that denote folder paths are binary
	 * folders, <em>i.e.</em> folders that contain {@code .class} files.
	 *
	 * @return a possibly empty list of pathnames denoting project classpath.
	 */
	List<File> getClasspath();

}