/*
 * Java
 *
 * 2020 ESR - Not subject to Copyright.
 * This document has been released and published by E-S-R consortium, a non-profit entity.
 * To learn more about E-S-R consortium, please visit http://www.e-s-r.net/.
 * The matter contained in this document is not subject to copyright; you are free to use it for any purpose, for more information see E-S-R consortium policies.
 */
package ej.microui.display;

import ej.microui.MicroUIException;

/**
 * A <code>BufferedImage</code> represents a mutable image backed by a pixel buffer.
 * <p>
 * The constructor of this class allows to create an image with given dimensions.
 */
public class BufferedImage extends ResourceImage {

	/**
	 * Creates a buffered image.
	 * <p>
	 * The new image is initialized with unspecified pixel data. The output format of the new image matches the pixel
	 * organization (layout, depth, etc.) of the default display.
	 * <p>
	 * Creating images is not supported by every MicroUI implementation. If the MicroUI implementation does not support
	 * the allocation of memory in order to store the pixel buffer, a {@link MicroUIException} is thrown.
	 *
	 * @param width
	 *            the width of the new image, in pixels.
	 * @param height
	 *            the height of the new image, in pixels.
	 * @throws IllegalArgumentException
	 *             if either <code>width</code> or <code>height</code> is negative or zero.
	 * @throws MicroUIException
	 *             if the image could not be created.
	 * @throws MicroUIException
	 *             if MicroUI is not started.
	 * @throws SecurityException
	 *             if a security manager exists and does not allow the caller to create an image.
	 */
	public BufferedImage(int width, int height) {
		throw new RuntimeException();
	}

	/**
	 * Returns the {@link GraphicsContext} associated with this image, which may be used in order to draw on the image.
	 * <p>
	 * This method always returns the same {@link GraphicsContext} instance for a specific image. The graphics context
	 * has the same dimensions as the image, which allows to modify every pixel of the image.
	 *
	 * @throws MicroUIException
	 *             if this image has been closed (see {@link ResourceImage#close()}).
	 * @return the image's graphics context.
	 */
	public GraphicsContext getGraphicsContext() {
		throw new RuntimeException();
	}

}
