/*
 * Java
 *
 * Copyright 2017-2019 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.util.text;

/**
 * Symbols using English language.
 */
public class EnglishDateFormatSymbols extends ComputeShortFormatSymbols {

	private static final String[] ERA = { "BC", "AD" }; //$NON-NLS-1$ //$NON-NLS-2$
	private static final String[] MONTH = { "January", "February", "March", "April", "May", "June", "July", "August", //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$
			"September", "October", "November", "December" }; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
	// private static final String[] SHORT_MONTH = { "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul",
	// "Aug", "Sep", "Oct", "Nov", "Dec" };
	private static final String[] DAY = { "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
			"Saturday" }; //$NON-NLS-1$
	// private static final String[] SHORT_DAY = { "Sun", "Mon", "Tue", "Wed", "Thu", "Fri",
	// "Saturday" };
	private static final String[] AMPM = { "AM", "PM" }; //$NON-NLS-1$ //$NON-NLS-2$

	/**
	 * Instantiating the English format symbols.
	 */
	public EnglishDateFormatSymbols() {
		setAmPmStrings(AMPM);
		setMonths(MONTH);
		setWeekdays(DAY);
		setEras(ERA);
	}

}
