/*
 * Copyright 2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.audio;

/**
 * Specifies the data format of an audio stream.
 */
public abstract class AudioFormat {

	/**
	 * Returns the encoding of this audio format.
	 *
	 * @return the encoding.
	 */
	protected abstract String getEncoding();

	/**
	 * Returns the parameters of this audio format.
	 * <p>
	 * The parameters depend on the encoding. The semantics of every parameter is known by the low-level audio
	 * implementation.
	 *
	 * @return the parameters.
	 */
	protected abstract int[] getParameters();
}
