/*
 * <Java>
 *
 * Copyright 2015-2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.service;

/**
 * Thrown when an error occurs while loading a service.
 *
 * @see ServiceLoader#getService(Class)
 */
public class ServiceLoadingException extends RuntimeException {

	private static final long serialVersionUID = -4400917385298484484L;

	/**
	 * Constructs a new service loading exception with the specified detail message and cause.
	 * <p>
	 * Note that the detail message associated with {@code cause} is <i>not</i> automatically incorporated in this
	 * service loading exception's detail message.
	 *
	 * @param message
	 *            the detail message (which is saved for later retrieval by the {@link #getMessage()} method).
	 * @param cause
	 *            the cause (which is saved for later retrieval by the {@link #getCause()} method). (A <tt>null</tt>
	 *            value is permitted, and indicates that the cause is nonexistent or unknown.)
	 */
	public ServiceLoadingException(String message, Throwable cause) {
		super(message, cause);
	}

}
