/*
 * Copyright 2024-2025 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package com.microej.wear;

import com.microej.wear.services.ComponentService;
import com.microej.wear.services.DeviceService;
import com.microej.wear.services.ExternalResourceService;
import com.microej.wear.services.FontService;
import com.microej.wear.services.HealthService;
import com.microej.wear.services.ResourceService;
import com.microej.wear.services.TimeService;

import ej.bon.Timer;

/**
 * Provides the instance of every Kernel service to the Features.
 */
public class KernelServiceProvider {

	private KernelServiceProvider() {
		// private constructor
	}

	/**
	 * Returns the timer instance.
	 *
	 * @return the timer instance.
	 */
	public static Timer getTimer() {
		throw new RuntimeException();
	}

	/**
	 * Returns the component service instance.
	 *
	 * @return the component service instance.
	 */
	public static ComponentService getComponentService() {
		throw new RuntimeException();
	}

	/**
	 * Returns the device service instance.
	 *
	 * @return the device service instance.
	 */
	public static DeviceService getDeviceService() {
		throw new RuntimeException();
	}

	/**
	 * Returns the external resources service instance.
	 *
	 * @return the external resources service instance.
	 */
	public static ExternalResourceService getExternalResourceService() {
		throw new RuntimeException();
	}

	/**
	 * Returns the font service instance.
	 *
	 * @return the font service instance.
	 */
	public static FontService getFontService() {
		throw new RuntimeException();
	}

	/**
	 * Returns the health service instance.
	 *
	 * @return the health service instance.
	 */
	public static HealthService getHealthService() {
		throw new RuntimeException();
	}

	/**
	 * Returns the resource service instance.
	 *
	 * @return the resource service instance.
	 */
	public static ResourceService getResourceService() {
		throw new RuntimeException();
	}

	/**
	 * Returns the time service instance.
	 *
	 * @return the time service instance.
	 */
	public static TimeService getTimeService() {
		throw new RuntimeException();
	}
}
