/*
 * Copyright 2014-2025 MicroEJ Corp.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.websocket.util;

/**
 * Classes providing basic tools to handle array.
 *
 */
public class ArraysTools {

	private ArraysTools() {
		// Forbid instantiation
	}

	/**
	 * Removes a range of data in an array.
	 *
	 * @param array
	 *            the array to remove the data.
	 * @param offset
	 *            the offset of the first element to remove
	 * @param length
	 *            the number of element to remove.
	 * @return a new array.
	 */
	public static byte[] removeRange(byte[] array, int offset, int length) {
		int arrayLength = array.length;
		byte[] newArray = new byte[arrayLength - length];
		System.arraycopy(array, 0, newArray, 0, offset);
		System.arraycopy(array, offset + length, newArray, offset, arrayLength - offset - length);
		return newArray;
	}

	/**
	 * Inserts a range of data in an array.
	 *
	 * @param array
	 *            the array to insert the data.
	 * @param offset
	 *            the offset of the place to insert the data.
	 * @param length
	 *            the number of element to insert.
	 * @return a new array.
	 */
	public static byte[] insertRange(byte[] array, int offset, int length) {
		int arrayLength = array.length;
		byte[] newArray = new byte[arrayLength + length];
		System.arraycopy(array, 0, newArray, 0, offset);
		System.arraycopy(array, offset, newArray, offset + length, arrayLength - offset);
		return newArray;
	}

	/**
	 * Appends two arrays into a new one.
	 *
	 * @param array
	 *            the first array.
	 * @param arrayOffset
	 *            the first array offset to start from.
	 * @param arrayLength
	 *            the length to take from the first array.
	 * @param other
	 *            the second array.
	 * @param otherOffset
	 *            the second array offset to start from.
	 * @param otherLength
	 *            the length to take from the second array.
	 * @return a new array.
	 */
	public static byte[] add(byte[] array, int arrayOffset, int arrayLength, byte[] other, int otherOffset,
			int otherLength) {
		byte[] result = new byte[arrayLength + otherLength];
		System.arraycopy(array, arrayOffset, result, 0, arrayLength);
		System.arraycopy(other, otherOffset, result, arrayLength, otherLength);
		return result;
	}
}
