/*
 * Java
 *
 * 2017-2022 ESR - Not subject to Copyright.
 *
 * This document has been released and published by E-S-R consortium, a non-profit entity.
 * To learn more about E-S-R consortium, please visit http://www.e-s-r.net/.
 * The matter contained in this document is not subject to copyright; you are free to use it for any purpose, for more information see E-S-R consortium policies.
 */
package ej.sni;

import java.io.IOException;

import ej.annotation.Nullable;

/**
 * {@link IOException} subclass that may be thrown from an SNI native using
 * <code>SNI_throwNativeIOException()</code> function.
 */
public class NativeIOException extends IOException {

	/**
	 * Constructs a new {@link NativeIOException} with the specified error code and detail
	 * message.
	 *
	 * @param errorCode the error code. The error code is saved for later retrieval by
	 * the {@link #getErrorCode()} method.
	 *
	 * @param errorMessage the detail message. The detail message is saved for later retrieval
	 * by the {@link #getMessage()} method.
	 */
	public NativeIOException(int errorCode, String errorMessage){
		throw new RuntimeException();
	}

	/**
	 * Constructs a new {@link NativeIOException} with the specified error code, detail message and cause.
	 *
	 * @param errorCode the error code. The error code is saved for later retrieval by
	 * the {@link #getErrorCode()} method.
	 *
	 * @param errorMessage the detail message. The detail message is saved for later retrieval
	 * by the {@link #getMessage()} method.
	 *
	 * @param cause the cause (which is saved for later retrieval by the {@link #getCause()} method).
	 * (A <tt>null</tt> value is permitted, and indicates that the cause is nonexistent or unknown.)
	 */
	public NativeIOException(int errorCode, String errorMessage, @Nullable Throwable cause) {
		throw new RuntimeException();
	}

	/**
	 * Returns the detail message string of this {@link NativeIOException}.
	 *
	 * @return the detail message string of this {@link NativeIOException} instance (which may be
	 *         {@code null}).
	 */
	@Override
	@Nullable
	public String getMessage() {
		throw new RuntimeException();
	}

	/**
	 * Returns the error code of this {@link NativeIOException}.
	 * @return the error code of this {@link NativeIOException} instance.
	 */
	public int getErrorCode(){
		throw new RuntimeException();
	}
}
