/*
 * Copyright 2025 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.net.util.ssl;

/**
 * Enumerates secure socket protocols.
 * <p>
 * See <a href="https://docs.oracle.com/en/java/javase/17/docs/specs/security/standard-names.html">Java
 * Specifications</a>.
 */
public class SslProtocols {

	private SslProtocols() {
		// private constructor
	}

	/** SSL protocol. */
	public static final String SSL = "SSL";
	/** SSLv2 protocol. */
	public static final String SSL_V2 = "SSLv2";
	/** SSLv3 protocol. */
	public static final String SSL_V3 = "SSLv3";

	/** TLS protocol. */
	public static final String TLS = "TLS";
	/** TLSv1 protocol. */
	public static final String TLS_V1 = "TLSv1";
	/** TLSv1.1 protocol. */
	public static final String TLS_V1_1 = "TLSv1.1";
	/** TLSv1.2 protocol. */
	public static final String TLS_V1_2 = "TLSv1.2";
	/** TLSv1.3 protocol. */
	public static final String TLS_V1_3 = "TLSv1.3";

	/** DTLS protocol. */
	public static final String DTLS = "DTLS";
	/** DTLSv1.0 protocol. */
	public static final String DTLS_V1_0 = "DTLSv1.0";
	/** DTLSv1.2 protocol. */
	public static final String DTLS_V1_2 = "DTLSv1.2";
}
